#include "cryptaid_processor.h"

namespace NMichurin {
    TCryptaIdProcessor::TCryptaIdProcessor(TCryptaIdProcessorBase::TConstructionArgs spArgs,
                                           const TCryptaIdStateProcessorConfig& config)
        : TCryptaIdProcessorBase(std::move(spArgs))
        , Config(config)
    {
        Y_UNUSED(Config);
    }

    TCryptaIdProcessor::TGroupedChunk TCryptaIdProcessor::PrepareGroupedChunk(TString dataSource,
                                                                              TCryptaIdProcessorBase::TManager& stateManager,
                                                                              TMessageBatch data) {
        YT_LOG_DEBUG("Parsed message of type %v", dataSource);
        TCryptaIdProcessor::TGroupedChunk result;
        for (auto& message : data.Messages) {
            message.Unpack();

            TCryptaIdEvent event{};
            TStringBuf skip;
            for (NFraming::TUnpacker unpacker(message.Data); unpacker.NextFrame(event, skip);) {
                const auto& gid = TGenericID(event.GetGid());
                const auto& cid = TGenericID(event.GetCid());
                YT_LOG_DEBUG("Got a request to write %v %v -> %v %v ",
                             gid.GetTypeString(), gid.GetValue(),
                             cid.GetTypeString(), cid.GetValue());
                auto stateRequest = stateManager.RequestState(gid.Serialize());
                result[std::move(stateRequest)].emplace_back(std::move(cid.ToProto()));
            }
        }
        return result;
    }

    void TCryptaIdProcessor::ProcessGroupedChunk(TString dataSource, TCryptaIdProcessor::TGroupedChunk groupedRows) {
        YT_LOG_DEBUG("Process message of type %v size %v", dataSource, groupedRows.size());
        for (auto& [request, rows] : groupedRows) {
            auto& state = request->GetState();
            for (auto& row : rows) {
                state.CopyFrom(row);
            }
        }
    }
}
