#pragma once

#include <ads/bsyeti/big_rt/lib/consuming_system/consuming_system.h>
#include <ads/bsyeti/big_rt/lib/utility/logging/logging.h>
#include <ads/bsyeti/big_rt/lib/deprecated/sensors/sensors.h>
#include <ads/bsyeti/big_rt/lib/deprecated/services/services.h>
#include <ads/bsyeti/big_rt/lib/supplier/supplier.h>
#include <ads/bsyeti/big_rt/lib/processing/shard_processor/stateful/processor.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/simple_proto/factory.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/simple_proto/manager.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/simple_proto/operator.h>

#include <crypta/graph/rt/sklejka/michurin/logger/logger.h>
#include <crypta/graph/rt/sklejka/michurin/proto/event.pb.h>
#include <crypta/graph/rt/sklejka/michurin/proto/state_processor_config.pb.h>
#include <crypta/lib/native/identifiers/lib/generic.h>

#include <library/cpp/framing/unpacker.h>

namespace NMichurin {
    using namespace NBigRT;
    using TGenericID = NIdentifiers::TGenericID;

    using TCryptaIdProcessorBase = TStatefulShardProcessor<
        TString,                                 // StateId
        NCrypta::NIdentifiersProto::TGenericID,  // State
        NCrypta::NIdentifiersProto::TGenericID>; // Chunk

    class TCryptaIdProcessor: public TCryptaIdProcessorBase {
    public:
        TCryptaIdProcessor(TCryptaIdProcessorBase::TConstructionArgs spArgs,
                           const TCryptaIdStateProcessorConfig& config);

        TCryptaIdProcessor::TGroupedChunk PrepareGroupedChunk(TString dataSource,
                                                              TCryptaIdProcessorBase::TManager& stateManager,
                                                              TMessageBatch data) override;

        void ProcessGroupedChunk(TString dataSource, TCryptaIdProcessor::TGroupedChunk groupedRows) override;

    private:
        const TCryptaIdStateProcessorConfig& Config;
    };

}
