#pragma once

#include <crypta/graph/rt/events/events.h>
#include <crypta/graph/rt/events/proto/event.pb.h>
#include <crypta/graph/rt/events/proto/michurin_bookkeeping.pb.h>

#include <crypta/graph/rt/lib/debounce_cache/debounce_cache.h>

#include <crypta/graph/rt/sklejka/michurin/proto/event.pb.h>
#include <crypta/graph/rt/sklejka/michurin/proto/state.pb.h>
#include <crypta/graph/rt/sklejka/michurin/proto/state_processor_config.pb.h>
#include <crypta/graph/rt/sklejka/michurin/proto/log_whitelist.pb.h>
#include <crypta/graph/rt/sklejka/michurin/graph_handler/graph_handler.h>
#include <crypta/graph/rt/sklejka/michurin/processors/michurin_state_manager_factory.h>
#include <crypta/graph/rt/sklejka/michurin/processors/state_change_request.h>
#include <crypta/graph/rt/lib/qyt_batch_multipacker/qyt_batch_multipacker.h>

#include <crypta/graph/engine/proto/graph.pb.h>

#include <crypta/lib/native/pqlib/producer.h>
#include <crypta/lib/proto/identifiers/identifiers.pb.h>

#include <ads/bsyeti/big_rt/lib/processing/state_manager/multiple/factory.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/simple_proto/factory.h>
#include <ads/bsyeti/big_rt/lib/processing/shard_processor/stateful/processor.h>

#include <library/cpp/blockcodecs/codecs.h>
#include <library/cpp/framing/unpacker.h>
#include <library/cpp/string_utils/base64/base64.h>

#include <util/system/env.h>

namespace NMichurin {
    using namespace NBigRT;
    using TRewindMetric = NSFStats::TSolomonThresholdMetric<0, 1, 2, 3, 4, 5>;

    using TMultipleMichurinStateDescriptor = TStateDescriptor<
        TMultipleStateManagerFactory<
            TMichurinStateManagerFactory<TMichurinState>>>;

    struct TMichurinDescriptors {
        TMultipleMichurinStateDescriptor MultipleMichurinDescriptor;
    };

    using TBookkeepingEvent = NCrypta::NEvent::TMichurinBookkeepingEvent;
    using TSimpleEventMessage = NCrypta::NEvent::TSimpleEventMessage;
    using TSoupEvent = NCrypta::NEvent::TSoupEvent;
    using ESource = NCrypta::NEvent::ESource;

    using TProducerPtr = TAtomicSharedPtr<NCrypta::NPQ::TProducer>;

    using TMichurinProcessorBase = TCompositeStatefulShardProcessor<TChangeRequest>;
    using TCryptaIdStateRequest = TGenericStateRequest<TString, NCrypta::NIdentifiersProto::TGenericID>;
    using TGenericStateRequestPtr = TCompositeStateRequest::THashable;

    using TGenericID = NIdentifiers::TGenericID;
    using TCryptaId = NIdentifiers::TCryptaId;

    using ELogLevel = ::NYT::NLogging::ELogLevel;
    using TLogWhitelistRule = NMichurin::TLogWhitelistRule;
    using TGraphHandlerPtr = THolder<TGraphHandler>;

    class TMichurinProcessor: public TMichurinProcessorBase {
    public:
        TMichurinProcessor(
            TMichurinProcessorBase::TConstructionArgs spArgs,
            const TMichurinStateProcessorConfig& config,
            TMichurinDescriptors descriptors,
            TProducerPtr rewindProducer);

        TGroupedChunk PrepareGroupedChunk(
            TString dataSource,
            TMichurinProcessorBase::TManager& stateManager,
            TMessageBatch data) override;

        void PrepareSoupEvent(const TSoupEvent& soupEvent, TMichurinProcessorBase::TManager& stateManager, TGroupedChunk& result);
        void PrepareBookkeepingEvent(const TBookkeepingEvent& bookkeepingEvent, TMichurinProcessorBase::TManager& stateManager, TGroupedChunk& result);

        void ProcessGroupedChunk(TString dataSource, TGroupedChunk groupedRows) override;
        void ProcessSoupRows(const TGenericStateRequestPtr& stateRequest, const TVector<TChangeRequest>& rows);
        void ProcessBookkeepingRows(const TGenericStateRequestPtr& stateRequest, const TVector<TChangeRequest>& rows);

        void ProcessSingleStateUpdates(const TGenericStateRequestPtr& stateRequest, const TVector<TChangeRequest>& rows);
        void ProcessMergeRequests(const TGenericStateRequestPtr& stateRequest, const TVector<TChangeRequest>& rows);
        void ProcessBookkeepingCidUpdate(const TGenericStateRequestPtr& stateRequest, const TVector<TChangeRequest>& rows);
        void ProcessBookkeepingTombstoneDelete(const TGenericStateRequestPtr& stateRequest);
        void ProcessBookkeepingSplit(const TGenericStateRequestPtr& stateRequest);
        void Run();

    private:
        void Rewind(const TSoupEvent& originalEvent);
        void Rewind(const TSoupEvent& originalEvent, ESource source, ui64 cidToSet);
        bool LimitEdges(TGraphHandlerPtr& handler);
        size_t ConvertToVulture(const TGraphHandlerPtr& handler);
        TSimpleEventMessage CreateVultEvent(const TString& key, const TAssociatedUids& associated);
        void SetCidRequest(const TGenericID& gid, const NCrypta::NIdentifiersProto::TGenericID& cid);
        void ClearInvalidState(TMichurinState& state);
        TGraphHandlerPtr GetHandlerSafe(TMichurinState& state);

        NSFStats::TSolomonContext GetStatsContext(TVector<NSFStats::TSolomonContext::TLabel> labels) const;
        NSFStats::TSolomonContext GetStatsContext(TVector<NSFStats::TSolomonContext::TLabel> labels, const TSoupEvent& event) const;

        void GetWhitelistRules();
        ELogLevel GetLogLevel(const TSoupEvent& event) const;
        ELogLevel GetLogLevel(const ui64& cryptaId) const;

        NYT::TFuture<TMichurinProcessor::TPrepareForAsyncWriteResult> PrepareForAsyncWrite() override;

        const TMichurinStateProcessorConfig& Config;
        TMichurinDescriptors Descriptors;
        TProducerPtr RewindProducer;

        THashSet<ui64> LogCryptaids;
        THashSet<ui64> LogShards;
        THashSet<TGenericID> LogGids;

        NRtSklejka::TQytBatchMultiPacker CidPacker;
        NRtSklejka::TQytBatchMultiPacker BruPacker;
        NRtSklejka::TQytBatchMultiPacker RewindPacker;

        TVector<TString> Rewinds;

        mutable NRtCrypta::TDebounceCache Debounce;
    };

    bool isFastForward(const TSoupEvent& event);

    const NCrypta::NIdentifiersProto::TGenericID ZeroCID{TCryptaId(TString("0")).ToProto()};
}
