#pragma once

#include <ads/bsyeti/big_rt/lib/utility/logging/logging.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/generic/manager.h>

#include <yt/yt/core/actions/public.h>
#include <yt/yt/client/api/public.h>

#include <util/generic/hash.h>
#include <util/generic/ptr.h>

#include "michurin_state_operator.h"

namespace NMichurin {
    using namespace NBigRT;

    template <typename TState_>
    class TMichurinStateManager: public TGenericStateManager<ui64, TState_> {
    public:
        using typename TGenericStateManager<ui64, TState_>::TStateId;
        using typename TGenericStateManager<ui64, TState_>::TState;

    private:
        using TBaseRequestPtr = TGenericStateRequestPtr<TStateId, TState>;

    public:
        explicit TMichurinStateManager(
            TStateManagerConfig config,
            TMichurinStateTableOperator stateOperator,
            NSFStats::TSolomonContext sensorsContext);
        explicit TMichurinStateManager(
            TStateManagerConfig config,
            TMichurinStateTableOperator stateOperator,
            const NYT::NProfiling::TTagSet& tags);

        NYT::TFuture<TVector<TBaseStateRequestPtr>> LoadStates(
            TVector<TBaseRequestPtr> requests,
            NYT::NApi::IClientPtr client,
            NYT::NTransactionClient::TTimestamp timestamp) override;

        TBaseStateManager::TStateWriter WriteStates(
            TVector<TBaseRequestPtr> requests) override;

        size_t SpaceUsed(const TState& state) override;

    private:
        TMichurinStateTableOperator StateOperator;
    };
}

#include "michurin_state_manager_inl.h"
