#pragma once

#include <util/generic/ptr.h>

#include "michurin_state_operator.h"
#include "michurin_state_manager.h"

#include <ads/bsyeti/big_rt/lib/utility/profiling/safe_stats_over_yt.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/generic/factory.h>
#include <ads/bsyeti/big_rt/lib/processing/state_manager/generic/manager.h>

#include <util/generic/yexception.h>
#include <util/generic/ptr.h>

namespace NMichurin {
    using namespace NBigRT;
    // State manager factory which handles storage of given proto state
    // with single string id into table passed via table operator.
    template <typename TState>
    class TMichurinStateManagerFactory: public TGenericStateManagerFactory<ui64, TState> {
    public:
        using TManager = TMichurinStateManager<TState>;

    public:
        explicit TMichurinStateManagerFactory(
            TStateManagerConfig managerConfig,
            TMichurinStateTableOperator stateOperator,
            NSFStats::TSolomonContext sensorsContext);
        explicit TMichurinStateManagerFactory(
            TStateManagerConfig managerConfig,
            TMichurinStateTableOperator stateOperator,
            const NYT::NProfiling::TTagSet& tags);

    public:
        TBaseStateManagerPtr Make(ui64 shard) override;

    protected:
        TMichurinStateTableOperator StateOperator;
    };
}

#include "michurin_state_manager_factory_inl.h"
