#pragma once

namespace NMichurin {
    template <typename TState>
    TMichurinStateManagerFactory<TState>::TMichurinStateManagerFactory(
        TStateManagerConfig managerConfig,
        TMichurinStateTableOperator stateOperator,
        NSFStats::TSolomonContext sensorsContext)
        : TGenericStateManagerFactory<ui64, TState>(std::move(managerConfig), std::move(sensorsContext))
        , StateOperator(std::move(stateOperator))
    {
    }

    template <typename TState>
    TMichurinStateManagerFactory<TState>::TMichurinStateManagerFactory(
        TStateManagerConfig managerConfig,
        TMichurinStateTableOperator stateOperator,
        const NYT::NProfiling::TTagSet& tags)
        : TMichurinStateManagerFactory(std::move(managerConfig), std::move(stateOperator), MakeSolomonContext(tags))
    {
    }

    template <typename TState>
    TBaseStateManagerPtr TMichurinStateManagerFactory<TState>::Make(ui64 /*shard*/) {
        return NYT::New<TManager>(
            this->ManagerConfig, StateOperator, this->SensorsContext);
    }
}
