#pragma once

#include <google/protobuf/text_format.h>

#include <yt/yt/client/api/client.h>
#include <yt/yt/client/api/transaction.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NMichurin {
    class TMichurinStateTableOperator {
    public:
        struct TOptions {
            TString Table;
            TString KeyColumn;
            // name of column with serialized proto
            TString ValueColumn;
            // name of column with codec which was used to compress value
            TMaybe<TString> CodecColumn = {};
            // any codec from library/cpp/blockcodecs
            TMaybe<TString> Codec = {};
        };

    public:
        TMichurinStateTableOperator(TOptions options);

        NYT::TFuture<TVector<TString>> Load(
            NYT::NApi::IClientPtr client, const TVector<ui64>& keys) const;

        template <typename TState>
        TVector<TState> Parse(const TVector<TString>& rows) const;

        template <typename TState>
        TVector<TString> Serialize(const TVector<TState>& states) const;

        void Write(
            NYT::NApi::ITransactionPtr tx,
            const TVector<ui64>& keys, const TVector<TString>& values) const;

    private:
        TOptions Options;
    };
}

#include "michurin_state_operator_inl.h"
