#pragma once

#include "michurin_state_operator.h"

namespace NMichurin {
    template <typename TState>
    TVector<TState> TMichurinStateTableOperator::Parse(
        const TVector<TString>& rows) const {
        TVector<TState> result(Reserve(rows.size()));

        for (auto& row : rows) {
            result.emplace_back();
            Y_PROTOBUF_SUPPRESS_NODISCARD result.back().ParseFromString(row);
        }

        return result;
    }

    template <typename TState>
    TVector<TString> TMichurinStateTableOperator::Serialize(
        const TVector<TState>& states) const {
        TVector<TString> values(Reserve(states.size()));

        for (auto& state : states) {
            values.emplace_back();
            Y_PROTOBUF_SUPPRESS_NODISCARD state.SerializeToString(&values.back());
        }

        return values;
    }
}
