#include "state_change_request.h"

namespace NMichurin {
    TChangeRequest::TChangeRequest(TChangeRequest&& other)
    {
        Swap(other);
    };

    TChangeRequest& TChangeRequest::operator=(TChangeRequest&& other) {
        Swap(other);
        return *this;
    }

    void TChangeRequest::Swap(TChangeRequest& other)
    {
        SoupEvent.Swap(&other.SoupEvent);
        BookkeepingEvent.Swap(&other.BookkeepingEvent);
        ToCid.Swap(&other.ToCid);
        std::swap(other.ChangeType, ChangeType);
    };

    TChangeRequest::TChangeRequest(const TSoupEvent& soupEvent)
    {
        ChangeType = SOUP_CHANGE;
        SoupEvent.CopyFrom(soupEvent);
    };

    TChangeRequest::TChangeRequest(const TSoupEvent& soupEvent, const NCrypta::NIdentifiersProto::TGenericID& toCid)
        : TChangeRequest(soupEvent)
    {
        ToCid.CopyFrom(toCid);
    };

    TChangeRequest::TChangeRequest(const TBookkeepingEvent& bookkeepingEvent, const NCrypta::NIdentifiersProto::TGenericID& toCid)
    {
        ChangeType = BOOKKEEPING_CHANGE;
        BookkeepingEvent.CopyFrom(bookkeepingEvent);
        ToCid.CopyFrom(toCid);
    };
}
