#pragma once

#include <ads/bsyeti/big_rt/lib/processing/state_manager/base/fwd.h>

#include <crypta/graph/rt/events/events.h>
#include <crypta/graph/rt/events/proto/event.pb.h>
#include <crypta/graph/rt/events/proto/soup.pb.h>
#include <crypta/graph/rt/events/proto/michurin_bookkeeping.pb.h>

#include <crypta/lib/native/identifiers/lib/generic.h>

#include <yt/yt/core/actions/public.h>

namespace NMichurin {
    enum EChangeType {
        SOUP_CHANGE,
        BOOKKEEPING_CHANGE,
    };
    using TSoupEvent = NCrypta::NEvent::TSoupEvent;
    using TBookkeepingEvent = NCrypta::NEvent::TMichurinBookkeepingEvent;
    using TGenericID = NIdentifiers::TGenericID;

    using ESourceType = NCrypta::NSoup::NSourceType::ESourceType;
    using ELogSourceType = NCrypta::NSoup::NLogSource::ELogSourceType;

    class TChangeRequest {
    public:
        TChangeRequest(const TSoupEvent& soupEvent, const NCrypta::NIdentifiersProto::TGenericID& toCid);
        TChangeRequest(const TSoupEvent& soupEvent);
        TChangeRequest(const TBookkeepingEvent& bookkeepingEvent, const NCrypta::NIdentifiersProto::TGenericID& toCid);
        TChangeRequest(const TChangeRequest& other) = default;
        TChangeRequest& operator=(const TChangeRequest&) = default;
        TChangeRequest(TChangeRequest&& other);
        TChangeRequest& operator=(TChangeRequest&&);
        ~TChangeRequest() = default;

        ESourceType GetSourceType() const {
            return SoupEvent.GetEdge().GetSourceType();
        };
        ELogSourceType GetLogSource() const {
            return SoupEvent.GetEdge().GetLogSource();
        };
        NCrypta::NIdentifiersProto::TGenericID GetGID1() const {
            return SoupEvent.GetEdge().GetVertex1();
        };
        NCrypta::NIdentifiersProto::TGenericID GetGID2() const {
            return SoupEvent.GetEdge().GetVertex2();
        };
        ui64 GetTimestamp() const {
            return SoupEvent.GetUnixtime();
        };
        ui64 GetCryptaId1() const {
            return SoupEvent.GetCryptaId1();
        };
        ui64 GetCryptaId2() const {
            return SoupEvent.GetCryptaId2();
        };
        ui32 GetCounter() const {
            return SoupEvent.GetCounter();
        };
        bool GetReversed() const {
            return SoupEvent.GetReversed();
        };
        bool GetMerge() const {
            return SoupEvent.GetMerge();
        };

        ui32 GetSeenCount() const {
            return SoupEvent.GetEdge().GetSeenCount();
        };

        const TSoupEvent GetSoupEvent() const {
            return SoupEvent;
        }

        NCrypta::NIdentifiersProto::TGenericID GetToCid() const {
            return ToCid;
        }

        NCrypta::NEvent::TMichurinBookkeepingEvent::EBookkeepingType GetBookkeepingEventType() const {
            return BookkeepingEvent.GetType();
        }

        EChangeType GetType() const {
            return ChangeType;
        }

    private:
        void Swap(TChangeRequest& other);

        TSoupEvent SoupEvent;
        TBookkeepingEvent BookkeepingEvent;
        NCrypta::NIdentifiersProto::TGenericID ToCid;
        EChangeType ChangeType;
    };
}
