import os
import argparse

from crypta.lib.proto.identifiers.identifiers_pb2 import TGenericID as TGenericIDProto
from crypta.lib.python.identifiers.generic_id import GenericID
from yweb.antimalware.libs import farmhash

import yt.wrapper as yt

DEFAULT_STATE_TABLE = "//home/crypta/production/rtsklejka/state/cryptaid_state"
STATE_TABLE = os.getenv('CID_STATE_TABLE', DEFAULT_STATE_TABLE)


def farm_hash(*values):
    result = 0xDEADC0DE
    for value in values:
        result = farmhash.farm_fingerprint(
            (result, farmhash.farm_fingerprint(value))
        )
    return result ^ len(values)


def check_cid_state(client, id_hash, path):
    rows = list(client.select_rows(
        "* FROM [{}] WHERE Hash={}".format(path, id_hash),
        format="yson",
    ))
    if not rows:
        print("No data")
        return

    row = rows[0]
    gid_bytes = yt.yson.get_bytes(row['Id'])
    gid_proto = TGenericIDProto.FromString(gid_bytes)
    gid = GenericID(proto=gid_proto)
    cid_bytes = yt.yson.get_bytes(row['CryptaId'])
    cid_proto = TGenericIDProto.FromString(cid_bytes)
    cid = GenericID(proto=cid_proto)
    print(
        "{}({}) has {}({})".format(
            gid_proto.WhichOneof('identifier'), gid.value,
            cid_proto.WhichOneof('identifier'), cid.value),
        end="")


def main():
    parser = argparse.ArgumentParser(prog='Read matcher state')
    parser.add_argument('--path', help='path', default=STATE_TABLE)
    parser.add_argument('--hash', help='hash')
    parser.add_argument('--type', help='type')
    parser.add_argument('--value', help='value')
    parser.add_argument('args', help='TYPE VALUE', nargs='*')

    args = parser.parse_args()
    print("Using STATE_TABLE: {}\n".format(args.path))

    client = yt.YtClient(proxy=os.getenv('YT_PROXY', 'hahn'))

    if args.hash:
        id_hash = args.hash
    elif args.type and args.value:
        gid = GenericID(args.type.lower(), args.value)
        id_hash = farm_hash(gid.serialize())
    elif len(args.args) == 2:
        gid = GenericID(args.args[0].lower(), args.args[1])
        id_hash = farm_hash(gid.serialize())
    else:
        print("use --hash or --type and --value")
        return

    print("=" * 20)
    check_cid_state(client, id_hash, args.path)
    print("\n" + "=" * 20)


if __name__ == "__main__":
    main()
