#include "algo.h"
#include "row.h"

#include <crypta/graph/rt/sklejka/lib/utils.h>

namespace {
    using namespace NResharder;

    // @brief IRowParser implementation for CryptaId algo
    class TShardCryptaId: public NBigRT::IShardingAlgorithm {
    public:
        TShardCryptaId() {
        }

        ui32 Shard(const NBigRT::TRow& row) const override {
            auto fields{dynamic_cast<TRowFields*>(row.Fields.Get())};
            if (fields->CryptaId != 0) {
                return fields->CryptaId;
            } else {
                return NCrypta::GenerateCryptaId(fields->Ids.front());
            }
        }
    };
}

namespace NResharder {
    NBigRT::IShardingAlgorithmPtr MakeSharder(const TString& algorithm) {
        if (algorithm == "CryptaId") {
            return MakeHolder<TShardCryptaId>();
        } else {
            return NBigRT::MakeSharder(algorithm);
        }
    }
}
