#pragma once

#include "algo.h"
#include "parsers.h"
#include "row.h"

#include <crypta/graph/rt/sklejka/cid_resolver/lib/resolver.h>
#include <crypta/graph/rt/sklejka/rows_processor/proto/config.pb.h>

#include <ads/bsyeti/big_rt/lib/processing/resharder/rows_processor/rows_processor.h>
#include <library/cpp/safe_stats/safe_stats.h>
#include <util/datetime/base.h>
#include <util/generic/strbuf.h>

namespace NResharder {
    class TBaseRowsProcessor: public NBigRT::IRowsProcessor {
    public:
        TBaseRowsProcessor(const TRowsProcessorConfig& config,
                           const ui32 reshardingModule,
                           const TString& destinationQueue,
                           const ui64 sampleShardsMax);

        bool IsAggregationTrivial() const override;

        void Aggregate(NSFStats::TSolomonContext& /* ctx */, const NBigRT::TRowsBatch& rows, THashMap<TString, TVector<NBigRT::TAggregatedRow>>& dst) const override;

        void Serialize(NSFStats::TSolomonContext& ctx, THashMap<TString, TVector<NBigRT::TAggregatedRow>>& src, THashMap<TString, TVector<NBigRT::TSerializedRow>>& output) const override;

        void SerializeSingleQueue(NSFStats::TSolomonContext& ctx, TVector<NBigRT::TAggregatedRow>& rows, TVector<NBigRT::TSerializedRow>& output) const;

        void Process(NSFStats::TSolomonContext& ctx, TInstant now, NBigRT::TRowsBatch& rows) const override;

    protected:
        const TString Splitter;
        const ui32 ReshardingModule;
        const NCrypta::NEvent::EMessageType MessageType;
        const size_t MaxMessageSize;
        const size_t MaxChunksCount;
        const TString Source;
        const NBigRT::IShardingAlgorithmPtr ShardingAlgorithm;
        const TString DestinationQueue_;
        const ui32 SampleShardsMax_;
    };
}
