#include "common.h"
#include "rows_processor.h"
#include "rows_processor_bookkeeping.h"

#include <crypta/graph/rt/events/events.h>

NBigRT::IRowsProcessorPtr NResharder::MakeRowsProcessor(const TString label,
                                                        const TRowsProcessorConfig& config,
                                                        const ui32 reshardingModule,
                                                        const TString& destinationQueue,
                                                        const ui64 sampleShardsMax,
                                                        const NCrypta::TCryptaIdResolverPtr cidResolver) {
    if (label.StartsWith("bookkeeping")) {
        return NYT::New<NResharder::TBookkeepingRowsProcessor>(config, reshardingModule, destinationQueue, sampleShardsMax);
    } else if (label == "resharder") {
        return NYT::New<NResharder::TRowsProcessor>(config, reshardingModule, destinationQueue, sampleShardsMax, cidResolver);
    } else {
        ythrow yexception() << "invalid ServantLabel " << label;
    }
}
