#pragma once

#include <crypta/graph/engine/proto/graph.pb.h>
#include <crypta/graph/soup/config/proto/bigb.pb.h>
#include <crypta/graph/rt/events/proto/soup.pb.h>

#include <util/generic/hash_set.h>

namespace NRtSklejka {
    using namespace NCrypta::NIdentifiersProto;
    using namespace NCrypta::NSoup;

    struct TConverterStats {
        uint32_t nonRtSkejkaEdges{0};
        uint32_t insignificantVertices{0};
    };

    class TConverterFromLinks {
    public:
        using TEdgeTypeTuple = std::tuple<NIdType::EIdType, NIdType::EIdType, NSourceType::ESourceType, NLogSource::ELogSourceType>;

        TConverterFromLinks(bool validateEdge);
        TConverterStats Convert(const NCrypta::NSoup::NBB::TLinks links, TVector<NCrypta::NEvent::TSoupEvent>& events) const;

    private:
        const THashSet<TEdgeTypeTuple> EdgeTypeWhitelist;

        THashSet<TEdgeTypeTuple> CreateWhiteList() const;
        const bool ValidateEdge;
    };
}
