#pragma once

#include "converter.h"
#include "exceptions.h"

#include <crypta/graph/rt/events/events.h>
#include <crypta/graph/rt/events/proto/soup.pb.h>
#include <crypta/graph/rt/lib/debounce_cache/debounce_cache.h>
#include <crypta/graph/rt/lib/parsers/parsers.h>
#include <crypta/graph/rt/sklejka/rows_processor/proto/config.pb.h>
#include <crypta/graph/soup/config/proto/bigb.pb.h>

#include <ads/bsyeti/big_rt/lib/processing/resharder/rows_processor/row.h>

namespace NResharder {
    using ISoupParser = NRtSklejka::IParser<TVector<NCrypta::NEvent::TSoupEvent>>;
    using IBookParser = NRtSklejka::IParser<NCrypta::NEvent::TMichurinBookkeepingEvent>;

    using ISoupParserPtr = NRtSklejka::IParserPtr<ISoupParser::TParseResult>;
    using IBookParserPtr = NRtSklejka::IParserPtr<IBookParser::TParseResult>;

    class TParserSoup: public ISoupParser {
    public:
        TParserSoup(const TRowsProcessorConfig::TParser::TFormat& config);

        ISoupParser::TParseResult Parse(TStringBuf text, NSFStats::TSolomonContext& ctx) const override;

    private:
        const bool Isb64Encoded;
        const bool ValidateEdge;
        const uint32_t MaxRewindCounter;

        NRtSklejka::TConverterStats Validate(const NCrypta::NEvent::TSoupEvent& msg) const;
    };

    class TParserLinks: public ISoupParser {
    public:
        TParserLinks(const TRowsProcessorConfig::TParser::TFormat& config);
        ISoupParser::TParseResult Parse(TStringBuf text, NSFStats::TSolomonContext& ctx) const override;

    private:
        bool IsInDebounceCache(const NCrypta::NEvent::TSoupEvent& event) const;
        void Validate(const NCrypta::NSoup::NBB::TLinks& links) const;

        const bool Isb64Encoded;
        mutable NRtCrypta::TDebounceCache Debounce;
        const ui64 MaxLinksAge;
        NRtSklejka::TConverterFromLinks Converter;
    };

    class TParserEmpty: public ISoupParser {
    public:
        TParserEmpty(const TRowsProcessorConfig::TParser::TFormat&);
        ISoupParser::TParseResult Parse(TStringBuf, NSFStats::TSolomonContext&) const override;
    };

    class TParserBookkeeping: public IBookParser {
    public:
        TParserBookkeeping(const TRowsProcessorConfig::TParser::TFormat& config);
        IBookParser::TParseResult Parse(TStringBuf text, NSFStats::TSolomonContext&) const override;

    private:
        const NCrypta::NEvent::TMichurinBookkeepingEvent::EBookkeepingType EventType;
    };

    template <typename T>
    NRtSklejka::IParserPtr<T> MakeParser(const TRowsProcessorConfig::TParser&) {
        static_assert(sizeof(T) != sizeof(T));
    }

    template <>
    NRtSklejka::IParserPtr<ISoupParser::TParseResult> MakeParser(const TRowsProcessorConfig::TParser&);
    template <>
    NRtSklejka::IParserPtr<IBookParser::TParseResult> MakeParser(const TRowsProcessorConfig::TParser&);
}
