#pragma once

#include "base_rows_processor.h"

namespace NResharder {
    class TRowsProcessor: public NResharder::TBaseRowsProcessor {
    public:
        TRowsProcessor(const TRowsProcessorConfig& config,
                       const ui32 reshardingModule,
                       const TString& destinationQueue,
                       const ui64 sampleShardsMax,
                       const NCrypta::TCryptaIdResolverPtr cIdResolver);

        void Parse(NSFStats::TSolomonContext& ctx, const NBigRT::TRowMeta& meta, TStringBuf message,
                   NBigRT::TRowsBatch& rows) const override;

        void Process(NSFStats::TSolomonContext& ctx, TInstant now, NBigRT::TRowsBatch& rows) const override;

    private:
        const ISoupParserPtr Parser;
        const NCrypta::TCryptaIdResolverPtr CIdResolver;

        void ParseRecord(const TStringBuf& record, NSFStats::TSolomonContext& ctx,
                         NBigRT::TRowsBatch& rows, const NBigRT::TRowMeta& meta) const;

        void ResolveCryptaIds(NSFStats::TSolomonContext& ctx, TInstant now, NBigRT::TRowsBatch& rows) const;
    };
}
