#pragma once

#include "base_rows_processor.h"

namespace NResharder {
    class TBookkeepingRowsProcessor: public TBaseRowsProcessor {
    public:
        TBookkeepingRowsProcessor(const TRowsProcessorConfig& config,
                                  const ui32 reshardingModule,
                                  const TString& destinationQueue,
                                  const ui64 sampleShardsMax);

        void Parse(NSFStats::TSolomonContext& ctx, const NBigRT::TRowMeta& meta, TStringBuf message,
                   NBigRT::TRowsBatch& rows) const override;

    private:
        const IBookParserPtr Parser;

        void ParseRecord(const TStringBuf& record, NSFStats::TSolomonContext& ctx,
                         NBigRT::TRowsBatch& rows, const NBigRT::TRowMeta& meta) const;
    };
}
