#pragma once

#include <contrib/libs/openssl/include/openssl/pem.h>
#include <contrib/libs/openssl/include/openssl/rsa.h>
#include <contrib/libs/openssl/include/openssl/evp.h>
#include <util/generic/string.h>

namespace NCrypta::NGraph {

class TDecryptor {
public:
    class TOpenSSLDelete {
    public:
        static void Destroy(BIO* bio) {
            BIO_free(bio);
        }
        static void Destroy(RSA* rsa) {
            RSA_free(rsa);
        }
        static void Destroy(EVP_CIPHER_CTX* ctx) {
            EVP_CIPHER_CTX_free(ctx);
        }
    };

    template <typename T>
    using TOpenSSLHolder = THolder<T, TOpenSSLDelete>;

    TDecryptor(const TString& rsaKey);
    TString Decrypt(const TString& di);

private:
    TOpenSSLHolder<BIO> KeyBio;
    TOpenSSLHolder<RSA> Rsa;
};

}
