#include "browserinfo.h"
#include <util/string/cast.h>

const TMap<int, TString> TDeviceInfo::index = {
    {0, "google_aid"},
    {1, "android_id"},
    {2, "device_id"},
    {3, "uuid"},
    {4, "ifa"},
    {5, "oaid"},
};

namespace {
    static const TString empty;
}

TBrowserInfo::TBrowserInfo(const TString& browserInfo) {
    bool iskey = true;
    TString key;

    for (const auto& it : StringSplitter(browserInfo).Split(':')) {
        if (iskey) {
            key = ToString(it.Token());
            if (key == "t") { // special case
                auto pos = browserInfo.find(":t:");
                Y_ENSURE(pos != TString::npos);
                bi[std::move(key)] = browserInfo.substr(pos + 3);
                break;
            }
        } else {
            bi[std::move(key)] = ToString(it.Token());
        }
        iskey = !iskey;
    }
}

const TString& TBrowserInfo::operator[](const TString& key) const {
    if (auto iter = bi.find(key); iter != bi.end()) {
        return iter->second;
    }
    return empty;
}

const TString& TDeviceInfo::operator[](const TString& key) const {
    if (auto iter = device_info.find(key); iter != device_info.end()) {
        return iter->second;
    }
    return empty;
}
