#pragma once

#include <util/generic/string.h>
#include <util/generic/map.h>
#include <util/generic/hash.h>
#include <util/string/split.h>
#include <library/cpp/json/easy_parse/json_easy_parser.h>

class TBrowserInfo {
private:
    THashMap<TString, TString> bi;

public:
    TBrowserInfo()
        : TBrowserInfo(TString{}){};
    TBrowserInfo(const TString& in);
    const TString& operator[](const TString& key) const;
};

class TDeviceInfo {
private:
    THashMap<TString, TString> device_info;

public:
    static const TMap<int, TString> index;
    TDeviceInfo(const TString& json) {
        NJson::TJsonParser jp = NJson::TJsonParser();
        TVector<TString> res;

        for (auto item : index) {
            jp.AddField(item.second, false);
        }

        bool result = jp.Parse(json, &res);
        if (result) {
            for (auto item : index) {
                device_info[item.second] = res[item.first];
            }
        }
    };
    const TString& operator[](const TString& key) const;
};
