#pragma once

#include <crypta/graph/rtdi-rt/proto/options.pb.h>
#include <mapreduce/yt/interface/client.h>
#include <util/datetime/base.h>
#include <util/generic/hash_set.h>
#include <util/string/builder.h>
#include <util/system/rwlock.h>

class TUuidStorage {
public:
    using TStorage = THashSet<TString>;

    TUuidStorage(const TYtConfig& ytConfig, TRtdiOptions::TKeyboardsExperiment expOptions);

    bool CheckIfDrop(ui64 yuid, const TString& uuid);
    bool IsEnabled();
    size_t Size();
    bool Update();

private:
    bool Enabled;
    TRWMutex AccessLock;
    TString TableName;
    ui64 ExperimentMask;
    TIntrusivePtr<NYT::IClient> YtClient;
    THolder<TStorage> StoragePtr;
    TString LastModificationTime{};
};
