#pragma once

#include <crypta/graph/rtdi-rt/proto/options.pb.h>
#include <crypta/lib/native/logbroker/logbroker.h>
#include <library/cpp/tvmauth/client/facade.h>

THolder<NCryptaLogbroker::TLogbrokerPuller> CreateLogBrokerPuller(const TRtdiOptions& options, std::shared_ptr<NTvmAuth::TTvmClient> tvmClient);

class TLogbrokerPusher {
public:
    struct TLogbrokerPusherConfig {
        size_t ThreadsCount;
        TString Server;
        ui16 Port;
        TString Topic;
        TString SourceId;
        ui32 TimeoutMs;
        ui32 LockTo;
        TString ServerStringTvmId;
        int PQlibLogPriority;
    };

private:
    TLogbrokerPusherConfig Options;
    TIntrusivePtr<NPersQueue::ILogger> Logger = nullptr;
    NPersQueue::TPQLib PQ;
    NPersQueue::TConsumerSettings ConsumerSettings;
    THolder<NPersQueue::IProducer> Producer;
    TAtomic Sequence = 0;
    TAtomic InFly = 0;

public:
    enum class EResult {
        E_OK,
        E_ERROR,
        E_TIMEOUT
    };

    TLogbrokerPusher(TLogbrokerPusherConfig options, std::shared_ptr<NTvmAuth::TTvmClient> tvmClient);
    EResult Push(const TString&);
    int GetSeq() const {
        return AtomicGet(Sequence);
    }
    int GetInFly() const {
        return AtomicGet(InFly);
    }
    int GetAndIncInFly() {
        return AtomicGetAndIncrement(InFly);
    }
    void DecInfly() {
        AtomicDecrement(InFly);
    }
};
