#pragma once

#include <library/cpp/neh/neh.h>
#include <library/cpp/neh/multiclient.h>
#include <library/cpp/neh/utils.h>

#include <util/string/builder.h>
#include <util/generic/hash.h>
#include <util/generic/maybe.h>
#include <util/string/vector.h>

#include "uploader.h"
#include <crypta/graph/rtdi-rt/proto/options.pb.h>
#include <crypta/graph/soup/config/cpp/soup_config.h>

class THttpSender {
    using THttpParams = THashMap<TString, TString>;
    using EIdType = NCrypta::NIdentifiersProto::NIdType::EIdType;

public:
    struct TMetrikaData {
        TMaybe<EIdType> IdType;
        TString DeviceId;
        TString MmDeviceId;
        TString Yuid;
        TString Uuid;
        TString Duid;
        ui64 Yuid64 = 0;
        ui64 Duid64 = 0;
        ui64 TimeStamp = 0;
        bool Private = false;
        bool PrivateFlag = false;
        bool PrivateTs = false;
    };

    enum class TReplyCode {
        OK,
        ERROR,
        TIMEOUT,
    };

private:
    TRtdiOptions::TUploaderOptions Options1;
    TRtdiOptions::TUploader2Options Options2;
    const TString ClientId;
    const THttpParams CommonParams1;
    const THttpParams CommonParams2;

    TReplyCode DoRequest(const TString& query, const TDuration timeout, const TString header);
    TString buildQueryWithParams(const TString& url, const THttpParams& params) const;

    /* idserv v1 */
    TString buildDevInfoQuery(const TMetrikaData& tm) const;
    TString buildYuidDevIdQuery(const TMetrikaData& tm) const;

    /* idserv v2 */
    TString buildYuidDevIdQuery2(const TMetrikaData& tm) const;
    TString getAttributies() const {
        using namespace NCrypta::NSoup;

        const auto& logSource = LogSourceType(NLogSource::ELogSourceType::WATCH_LOG);
        const auto& sourceType = SourceType(NSourceType::ESourceType::RTDI);

        return TStringBuilder{} << "log_source:" << logSource.GetName()
                                << ",source_type:" << sourceType.GetName();
    }

public:
    THttpSender(const TRtdiOptions& options)
        : Options1(options.GetUploaderOptions())
        , Options2(options.GetUploader2Options())
        , ClientId(options.GetTvmOptions().GetClientAlias())
        , CommonParams1{
              {"header.version", "VERSION_4_10"},
              {"body.ttl", "86400"},
              {"header.type", "UPLOAD"},
              {"header.client", ClientId}}
        , CommonParams2{{"@match_online", "true"}, {"@serialize", Options2.GetSerializeType()}, {"@online_node_attrs", getAttributies()}, {"@online_edge_attrs", getAttributies()}} {
    }

    TReplyCode DoSend(const TMetrikaData& tm);
    TReplyCode DoSend2(const TMetrikaData& tm, TString header);
};
