#include <util/system/env.h>
#include <kikimr/persqueue/sdk/deprecated/cpp/v2/logger.h>

#include <crypta/graph/rtdi-rt/lib/rtdi.h>
#include <crypta/graph/rtdi-rt/proto/options.pb.h>

#include <crypta/lib/native/cmd_args/parse_pb_options.h>

bool Do = true;

void SigHandler(int) {
    Do = false;
}
int main(int argc, const char** argv) {
    /* parse options */
    try {
        auto config = NCrypta::ParsePbOptions<TRtdiOptions>(argc, argv);

        /* Get secrets from env variables and check them set */
        TString secret = GetEnv("CLIENT_TVM_SECRET", "");
        Y_ENSURE(!secret.empty(), "Set CLIENT_TVM_SECRET env variable.");

        config.MutableTvmOptions()->SetClientTvmSecret(secret.data());

        TString metrikaKey = GetEnv("METRIKA_PRIVATE_KEY", "");
        Y_ENSURE(!metrikaKey.empty(), "Set METRIKA_PRIVATE_KEY env variable.");
        config.SetMetrikaKey(metrikaKey);

        /* setup stop signals */
        signal(SIGTERM, SigHandler);
        signal(SIGINT, SigHandler);

        DoInitGlobalLog(
            CreateLogBackend(config.GetLogOptions().GetType(),
                             static_cast<ELogPriority>(config.GetLogOptions().GetMainPriority()),
                             true));

        INFO_LOG << "Reading: " << config.GetLogbrokerOptions().GetServer() << "/"
                 << config.GetLogbrokerOptions().GetTopic() << " by "
                 << config.GetTvmOptions().GetClientAlias() << ". "
                 << "Locked sessions: " << config.GetLogbrokerOptions().GetUseLockSession() << Endl;
        INFO_LOG << "Uploading to: " << config.GetUploaderOptions().GetUrl() << "("
                 << config.GetUploaderOptions().GetEnabled() << "), "
                 << config.GetUploader2Options().GetUrl() << "("
                 << config.GetUploader2Options().GetEnabled() << ")" << Endl;
        INFO_LOG << "Using Experiment: " << config.GetExperimentOptions().GetEnabled() << ". "
                 << "Dropping: " << config.GetDropAll() << Endl;

        /* process */
        TRtdi rtdi(config);
        rtdi.Start();
        while (Do) {
            Sleep(TDuration::MilliSeconds(100));
        }
    } catch (const yexception& e) {
        ERROR_LOG << e.what() << Endl;
        return 1;
    }

    return 0;
}
