#!/bin/bash

DC=$(echo ${DEPLOY_NODE_DC:-$QLOUD_DATACENTER} | awk '{print tolower($0)}')

ENV=${CRYPTA_ENVIRONMENT:-testing}

case "${ENV}" in
    production)
        /rtdi-rt \
            --lb-use-lock-session \
            --tvm-client-alias=crypta-rtdi-prod \
            --tvm-client-tvm-id=2001381 \
            --http-listen-at="http://*:4243/" \
            --solomon-labels dc=${DC} \
            --lb-vulture-enable-upload=yes \
            --lb-vulture-usage=1 \
            --lb-vulture-private-policy=UPLOAD_ALL_PRIVATE \
            --lb-server=${DC}.logbroker.yandex.net
        ;;
    testing)
        /rtdi-rt \
            --exp-enabled \
            --lb-use-lock-session \
            --uploader2-url="http://id-test.crypta.yandex.net:80/identify" \
            --uploader-url="http://idserv-test.rtcrypta.yandex.net:8080/json/upload" \
            --solomon-labels dc=${DC} \
            --lb-vulture-private-policy=UPLOAD_ALL_PRIVATE \
            --lb-server=${DC}.logbroker.yandex.net \
            --rps-limit=40 \
            --sample-yuid-by=1 \
            --uploader2-server-tvm-id=2000649 \
            --uploader2-serialize-type=all \
            --lb-vulture-enable-upload=yes \
            --lb-vulture-usage=2
        ;;
    *)
        echo set the CRYPTA_ENVIRONMENT variable to {production, testing}
        sleep 1
        ;;
esac
