#pragma once

#include <crypta/graph/rtmr/lib/resources/resources.h>
#include <crypta/graph/rtmr/proto/hit_event_data.pb.h>
#include <crypta/lib/native/rtmr/proto_stateful_operation/proto_stateful_operation.h>
#include <crypta/lib/native/rtmr/tskv_parser_mapper/tskv_parser_mapper.h>

#include <kernel/geo/utils.h>

namespace NCrypta::NGraph {
    class THitEventMapper: public TTskvParserMapper {
    public:
        THitEventMapper(const TGeobaseLookup& geoData);

    protected:
        const TGeobaseLookup& GeoData;
    };

    class TEventMapper: public THitEventMapper {
    public:
        enum EOutputTo {
            HitlogIdJoin = 0,
            YClidJoin = 1,
            Errors = 2
        };
        TEventMapper(const TGeobaseLookup& geoData);

    protected:
        virtual void DoParsed(const NYT::TNode& parsed, TWriter* writer) override;
    };

    class THitMapper: public THitEventMapper {
    public:
        enum EOutputTo {
            HitlogIdJoin = 0,
            Errors = 1
        };
        THitMapper(const TResources& resources, const TGeobaseLookup& geoData);

    protected:
        virtual void DoParsed(const NYT::TNode& parsed, TWriter* writer) override;

    private:
        const TResources& Resources;
        TResources::TResourcesHolder ResourceHolder;
        const uatraits::detector& Detector;
    };

    class THitlogIdReducer: public TProtoStatefulReducer<THitEventData> {
    public:
        THitlogIdReducer(const TResources& resources, const TGeobaseLookup& geoData);
        void Do(TReader* reader, TWriter* writer) override;
        static TString GetFingerprint(const THitEventData& data);
    private:
        enum EOutputTo {
            Join = 0,
            ToDeduplicator = 1,
            Errors = 2,
        };

        const TResources& Resources;
        const TGeobaseLookup& GeoData;
    };
}
