#include <util/string/cast.h>
#include <util/string/split.h>

namespace NCrypta::NGraph::NBrowserInfo {
    TString GetValue(const TString& browserInfo, const TString& key) {
        if (key.empty() || browserInfo.empty()) {
            return {};
        }

        bool found = false;
        bool iskey = true;

        for (const auto& it : StringSplitter(browserInfo).Split(':')) {
            if (iskey) {
                auto bikey = it.Token();

                if (bikey == "t") {
                    if (key != bikey) {
                        return {};
                    }

                    auto pos = browserInfo.find(":t:");
                    Y_ENSURE(pos != TString::npos);
                    return browserInfo.substr(pos + 3);
                }

                if (bikey == key) {
                    found = true;
                }
            } else {
                if (found) {
                    return ToString(it.Token());
                }
            }
            iskey = !iskey;
        }
        return {};
    }
}
