#include "get_normalized_host.h"

#include <library/cpp/cgiparam/cgiparam.h>
#include <library/cpp/uri/uri.h>

using namespace NUri;

TMaybe<TString> NCrypta::NGraph::GetNormalizedHost(const TStringBuf& url) {
    const TParseFlags& parseFlags(TUri::FeaturesRecommended);
    TUri normalizedUrl;

    if (normalizedUrl.ParseAbs(url, parseFlags) != TUri::ParsedOK) {
        return Nothing();
    }

    if (normalizedUrl.GetScheme() != TUri::EKind::SchemeHTTP && normalizedUrl.GetScheme() != TUri::EKind::SchemeHTTPS) {
        return Nothing();
    }

    const auto& host = normalizedUrl.GetHost();
    return host.empty() ? Nothing() : TMaybe<TString>(host);
}

TMaybe<TString> NCrypta::NGraph::GetParam(const TStringBuf& url, const TStringBuf paramName) {
    TUri parsed;
    if (parsed.ParseAbs(url, {TUri::FeaturesRecommended}) != TUri::ParsedOK) {
        return Nothing();
    }

    const auto& qs = parsed.GetField(TField::FieldQuery);
    if (qs.empty()) {
        return Nothing();
    }

    TCgiParameters queryParams;
    queryParams.Scan(qs);
    if (!queryParams.Has(paramName)) {
        return Nothing();
    }

    return queryParams.Get(paramName);
}
