#include "get_source_by_ip.h"

namespace NCrypta::NGraph {
    TString GetSourceByIpSafe(const NGeobase::TLookup& geoData, const TString& ip) {
        try {
            return geoData.GetTraitsByIp(ip).IspName;
        } catch(...) {
        }

        return {};
    }

    TString GetSourceByIpSafe(const NGeobase::TLookup& geoData, const TStringBuf ip) {
        return GetSourceByIpSafe(geoData, TString{ip});
    }
}
