#include "make_parsed_bs_watch_row.h"

#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <yabs/server/libs/server/build_fixed_level_domain/build_fixed_level_domain.h>

#include <util/digest/murmur.h>
#include <util/stream/format.h>
#include <util/string/cast.h>
#include <util/string/hex.h>

namespace {
    TString GetTrait(const uatraits::detector::result_type& traits, const std::string& trait) {
        const auto& it = traits.find(trait);
        return it == traits.end() ? TString() : TString(it->second);
    }
}

namespace NCrypta::NGraph {
    TParsedBsWatchRow MakeBsWatchRow(
        const TString& domainUserID,
        const TString& originalDomain,
        const uatraits::detector::result_type& traits,
        i64 timestamp,
        const TString& yuid,
        const TString& source
    ) {
        TParsedBsWatchRow row;

        const auto& domain = BuildFixedLevelDomain(originalDomain.data(), 2);

        row.SetFpc(domainUserID);
        row.SetOSVersion(GetTrait(traits, "OSVersion"));
        row.SetOSFamily(GetTrait(traits, "OSFamily"));
        row.SetOriginalDomain(originalDomain);
        row.SetDomain(domain);
        row.SetBrowserName(GetTrait(traits, "BrowserName"));
        row.SetBrowserVersion(GetTrait(traits, "BrowserVersion"));
        row.SetTimestamp(timestamp);
        row.SetYuid(yuid);
        row.SetSource(source);

        return row;
    }

    TString MakeParsedBsWatchRow(const TParsedBsWatchRow& row) {
        return NProtoSerializer::ToString(row);
    }
}
