#include "serialize_fingerprint_match.h"

#include <crypta/lib/native/time/shifted_clock.h>
#include <library/cpp/json/json_writer.h>
#include <util/generic/ymath.h>
#include <util/stream/str.h>

using namespace NCrypta;

namespace {
    const char* const BROWSER = "browser";
    const char* const BROWSER_VERSION = "browser_version";
    const char* const DOMAIN_ = "domain";
    const char* const DOMAIN_COOKIE = "domain_cookie";
    const char* const ORIGINAL_DOMAIN = "original_domain";
    const char* const OS_VERSION = "osversion";
    const char* const OS_FAMILY = "osfamily";
    const char* const TIMESTAMP = "timestamp";
    const char* const YUID = "yuid";
    const char* const SOURCE = "source";
    const char* const CURRENT_TS = "current_ts";
}

TString NGraph::SerializeMatch(const TString& yuid,
    const TParsedBsWatchRow& bsWatchRow,
    const TString& source) {
    TStringStream stream;
    NJson::TJsonWriter writer(&stream, false);

    writer.OpenMap();

    writer.Write(BROWSER, bsWatchRow.GetBrowserName());
    writer.Write(BROWSER_VERSION, bsWatchRow.GetBrowserVersion());
    writer.Write(DOMAIN_, bsWatchRow.GetDomain());
    writer.Write(DOMAIN_COOKIE, bsWatchRow.GetFpc());
    writer.Write(ORIGINAL_DOMAIN, bsWatchRow.GetOriginalDomain());
    writer.Write(OS_VERSION, bsWatchRow.GetOSVersion());
    writer.Write(OS_FAMILY, bsWatchRow.GetOSFamily());
    writer.Write(TIMESTAMP, bsWatchRow.GetTimestamp());
    writer.Write(YUID, yuid);
    writer.Write(SOURCE, source);
    writer.Write(CURRENT_TS, TShiftedClock::Now().Seconds());

    writer.CloseMap();
    writer.Flush();

    return stream.Str();
}

TString NGraph::SerializeFingerprintMatch(const TYuidMessage& yuidMessage,
    const TParsedBsWatchRow& bsWatchRow,
    const TString& source) {

    return SerializeMatch(yuidMessage.GetYandexuid(), bsWatchRow, source);
}
