#pragma once

#include <crypta/lib/native/identifiers/lib/id_types/all.h>
#include <metrika/uatraits/include/uatraits/detector.hpp>
#include <library/cpp/geobase/lookup.hpp>
#include <kernel/geo/types/region_types.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NCrypta::NGraph {
    bool IsYandexDomain(const TString& domain);
    bool IsYastaticDomain(const TString& domain);
    bool IsCorrectDomain(const TString& domain);
    bool IsCorrectDomain(const TMaybe<TString>& domain);
    bool ValidateDomain(const TString& domain);
    bool ValidateDomain(const TMaybe<TString>& domain);
    bool ValidateDomainUserID(const TString& duid);
    bool ValidateUATraits(const uatraits::detector::result_type& traits);
    bool ValidateBrowserInfo(const TString&);
    bool ValidateCounterID(const TString&);
    bool ValidateYandexuid(const TString&);
    bool ValidateYandexReferer(const TString&, const TMaybe<TString>&);
    bool ShouldSaveYuid(const TString& browserInfo);
    bool ValidateSslSessionTicketIV(const TString&);
    bool ValidateHitlogId(const TString& hitlogId);
    bool ValidateYClid(const TString& yclid);
    bool ValidateAddress(const TString&);
    bool ValidateAddress4(const TString&);
    bool ValidateAddress6(const TString&);
    bool ValidatePort(const TString&);

    bool IsGDPR(const NGeobase::TLookup& geoData, TGeoRegion regionId);
    bool IsGDPR(const NGeobase::TLookup& geoData, const TString& regionId);
    bool IsPrivateRelayIp(const NGeobase::TLookup& geoData, const TString& ipAddress);
    bool IsRostelecomExtfp(const TString& browserInfo);

    template <typename T>
    bool IsValidIdentifier(const TString& value) {
        T id{value};

        return id.IsValid();
    }
}
