#include "deduplicator.h"

#include <crypta/lib/native/time/shifted_clock.h>

namespace NCrypta::NGraph {
    TDedupliateReducer::TDedupliateReducer(int waitPeriod)
    : WaitPeriod(TDuration::Seconds(waitPeriod))
    {
        TShiftedClock::FreezeTimestampFromEnv();
    }

    void TDedupliateReducer::Do(TReader* reader, TWriter* writer) {
        for (; reader->IsValid(); reader->Next()) {
            const auto& row = reader->GetRow();

            int tableIndex;
            if (!TryFromString(row.SubKey, tableIndex)) {
                continue;
            }

            auto now = TShiftedClock::Now();
            auto sinceLastUpload = now - TInstant::Seconds(State.GetLastUploadTs());

            if (sinceLastUpload > WaitPeriod) {
                State.SetLastUploadTs(now.Seconds());
                writer->AddRow({row.Key, row.SubKey, row.Value}, tableIndex);
            }

            break; // we get data grouped by key, so other rows are duplicates
        }
    }
}
