#pragma once

#include <crypta/graph/rtmr/proto/deduplicator_state.pb.h>
#include <crypta/lib/native/rtmr/proto_stateful_operation/proto_stateful_operation.h>

#include <util/datetime/base.h>

namespace NCrypta::NGraph {
    class TDedupliateReducer: public TProtoStatefulReducer<TDeduplicateReducerState> {
    public:
        constexpr static int DefaultWaitPeriodInSeconds = 30 * 60;
        TDedupliateReducer(int waitPeriod = DefaultWaitPeriodInSeconds);

        // uses SubKey as an output table index!
        void Do(TReader* reader, TWriter* writer) override;

    private:
        TDuration WaitPeriod;
    };
}
