#include "factory.h"

#include <crypta/graph/rtmr/lib/bs_hit_event/bs_hit_event.h>
#include <crypta/graph/rtmr/lib/deduplicator/deduplicator.h>
#include <crypta/graph/rtmr/lib/join_fingerprints/join_fingerprints.h>
#include <crypta/graph/rtmr/lib/parse_adstat_log/parse_adstat_log.h>
#include <crypta/graph/rtmr/lib/parse_bs_watch_log/parse_bs_watch_log.h>
#include <crypta/graph/rtmr/lib/parse_extfp_match_log/parse_extfp_match_log.h>
#include <crypta/graph/rtmr/lib/parse_redir_log/parse_redir_log.h>
#include <crypta/graph/rtmr/lib/parse_zen_log/parse_zen_log.h>
#include <crypta/graph/rtmr/lib/resources/resources.h>
#include <crypta/graph/rtmr/lib/tls_reducer/tls_reducer.h>
#include <crypta/graph/rtmr/lib/yclid_reducer/yclid_reducer.h>
#include <crypta/graph/rtmr/proto/options.pb.h>
#include <crypta/lib/native/cmd_args/parse_pb_options.h>
#include <crypta/lib/native/time/shifted_clock.h>

#include <rtmapreduce/libs/mapreduce-yt/operation.h>

using namespace NRTMR::NTask;
using namespace NCrypta;
using namespace NGraph;

namespace {
    TResources& GetResources(const NResourceService::TServiceOptions& options) {
        static TResources resources(options);
        return resources;
    }

    const NGeobase::TLookup& GetGeoData(const TString& filepath) {
        static NGeobase::TLookup geodata(filepath);
        return geodata;
    }

    void SetFrozenTime(ui64 frozenTime) {
        if (frozenTime) {
            TShiftedClock::FreezeTimestamp(frozenTime);
        }
    }
}

TOperationPtr TGraphFactory::CreateOperation(const TString& name, const TTaskContextPtr& context) {
    const auto& options = ParsePbOptions<TOperationOptions>(context->GetArgc(), context->GetArgv());

    SetFrozenTime(options.GetFrozenTime());
    auto& resources = GetResources(options.GetResourceServiceOptions());

    if (name == "parse_redir_log") {
        return NewOperation<TParseRedirLog>(resources);
    } else if (name == "parse_zen_log") {
        return NewOperation<TParseZenLog>(resources);
    } else if (name == "parse_bs_watch_log") {
        return NewOperation<TParseBsWatchLog>(resources, GetGeoData(options.GetGeoDataPath()));
    } else if (name == "join_fingerprints") {
        return NewOperation<TJoinFingerprints>(resources);
    } else if (name == "tls_reducer") {
        return NewOperation<TTlsReducer>();
    } else if (name == "bs_event_mapper") {
        return NewOperation<TEventMapper>(GetGeoData(options.GetGeoDataPath()));
    } else if (name == "bs_hit_mapper") {
        return NewOperation<THitMapper>(resources, GetGeoData(options.GetGeoDataPath()));
    } else if (name == "hitlogid_reducer") {
        return NewOperation<THitlogIdReducer>(resources, GetGeoData(options.GetGeoDataPath()));
    } else if (name == "yclid_reducer") {
        return NewOperation<TYClidReducer>();
    } else if (name == "parse_extfp_match_log") {
        return NewOperation<TParseExtfpMatchLog>(resources);
    } else if (name == "parse_adstat_log") {
        return NewOperation<TParseAdstatLog>(resources);
    } else if (name == "deduplicate_reducer") {
        return NewOperation<TDedupliateReducer>(options.GetDeduplicatePeriod());
    }

    return nullptr;
}
