#pragma once

#include "new_match_getter.h"

#include <crypta/graph/rtmr/lib/resources/resources.h>
#include <crypta/graph/rtmr/proto/join_fingerprints_state.pb.h>
#include <crypta/graph/rtmr/proto/parsed_bs_watch_row.pb.h>
#include <crypta/graph/rtmr/proto/yuid_message.pb.h>
#include <crypta/lib/native/rtmr/proto_stateful_operation/proto_stateful_operation.h>

namespace NCrypta::NGraph {
    class TJoinFingerprints : public TProtoStatefulReducer<TJoinFingerprintsState> {
    public:
        TJoinFingerprints(const TResources& resources);
        ~TJoinFingerprints() override = default;

        void Do(TReader* reader, TWriter* writer) override;
    private:
        using TBase = TProtoStatefulReducer<TJoinFingerprintsState>;

        enum EInputTable {
            BsWatchLog,
            RedirLog
        };

        enum EOutputTable {
            Output,
            Errors
        };

        const TResources& Resources;
        TParsedBsWatchRow BsWatchRow;
        TYuidMessage YuidMessage;
        TNewMatchGetter NewMatchGetter;
    };
}
