#pragma once

#include <crypta/graph/rtmr/proto/config.pb.h>
#include <crypta/graph/rtmr/proto/join_fingerprints_state.pb.h>
#include <crypta/graph/rtmr/proto/parsed_bs_watch_row.pb.h>
#include <crypta/graph/rtmr/proto/yuid_message.pb.h>

#include <util/generic/hash_set.h>
#include <util/generic/vector.h>

namespace NCrypta::NGraph {
    class TNewMatchGetter {
    public:
        using TMatches = TVector<std::pair<const TYuidMessage*, const TParsedBsWatchRow*>>;

        TNewMatchGetter();

        void AddYuidEvent(TYuidMessage&& row);
        void AddBsWatchEvent(TParsedBsWatchRow&& row);
        TMatches GetNewReports(TJoinFingerprintsState& state, time_t maxTimestamp, const TConfig& config);

    private:
        struct TRememberedMatchEqualTo {
            bool operator()(const TRememberedMatch& a, const TRememberedMatch& b) const;
        };

        struct TRememberedMatchHash {
            size_t operator()(const TRememberedMatch& a) const;
        };

        using TRememberedMatchSet = THashSet<TRememberedMatch, TRememberedMatchHash, TRememberedMatchEqualTo>;
        using TRepeatedBsWatch = ::google::protobuf::RepeatedPtrField<TParsedBsWatchRow>;
        using TRepeatedYuids = ::google::protobuf::RepeatedPtrField<TYuidMessage>;
        using TRepeatedRememberedMatch = ::google::protobuf::RepeatedPtrField<TRememberedMatch>;

        TRememberedMatchSet GetRememberedMatchSet(TRepeatedRememberedMatch& reportedMatches, const time_t minTs);

        TMatches CollectNewMatches(
            const TRepeatedBsWatch& bsWatchHistory,
            const TRepeatedYuids& yuidHistory,
            const time_t timeWindow,
            const size_t validMatchLimit,
            TRememberedMatchSet& rememberedMatchSet);

        bool NeedToReport(
            const TYuidMessage& yuidMessage,
            const TParsedBsWatchRow& bsWatchRow,
            const time_t timeWindow,
            TRememberedMatchSet& rememberedMatchSet);

        void UpdateRememberedMatches(
            TRepeatedRememberedMatch& output,
            const TRememberedMatchSet& rememberedMatchSet,
            const i64 rememberedMatchLimit) const;

        TRepeatedBsWatch BsWatchEvents;
        TRepeatedBsWatch BsWatchBuffer;

        TRepeatedYuids YuidEvents;
        TRepeatedYuids YuidBuffer;

        TRememberedMatch RememberedMatchBuffer;
    };
}
