#pragma once

#include <crypta/graph/rtmr/lib/resources/resources.h>
#include <crypta/graph/rtmr/proto/parsed_bs_watch_row.pb.h>
#include <rtmapreduce/libs/mapreduce-yt/operation.h>

namespace NCrypta::NGraph {
    class TParseAdstatLog: public NYT::IMapper<NYT::TYaMRReader, NYT::TYaMRWriter> {
    public:
        TParseAdstatLog(const TResources& resources);
        void Do(TReader* reader, TWriter* writer) override;

    private:
        enum EOutputTable {
            Join,
            Errors
        };

        enum class EParseResult {
            Ok,
            Error,
            Invalid,
            NotItp,
            NotInitialized,
        };

        struct TParseResult {
            EParseResult ErrorCode{EParseResult::NotInitialized};
            TString ExtId;
            TString Message;
        };

        TParseResult ParseMessage(const TStringBuf row, const uatraits::detector& detector) const;
        void ParseRow(const TReader::TRowType& row,
                      const uatraits::detector& detector,
                      TWriter* writer) const;

        const TResources& Resources;
    };
}
