#include "unmask.h"

namespace NCrypta::NGraph::NMask {
    const TString& TMask::Get() const {
        return Mask;
    }

    const TString& TMaskedValue::Get() const {
        return MaskedValue;
    }

    TMaybe<TString> Unmask(const TMask& mask_, const TMaskedValue& maskedValue_) {
        const static size_t minimalIdSize{16};
        const auto& mask = mask_.Get();
        const auto& maskedValue = maskedValue_.Get();

        if (mask.size() < minimalIdSize || mask.size() != maskedValue.size()) {
            return Nothing();
        }

        TString result(mask.size(), 0);
        for (size_t i=0; i<mask.size(); ++i) {
            if (mask[i] < '0' || maskedValue[i] < '0' || mask[i] > '9' || maskedValue[i] > '9') {
                return Nothing();
            }

            result[i] = '0' + ((10 + maskedValue[i] - mask[i]) % 10);
        }

        return result;
    }
}
