#pragma once

#include "unmask.h"

#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NCrypta::NGraph::NMask {
    class TMask {
    public:
        explicit TMask(const TString& mask)
        : Mask(mask)
        {}
        const TString& Get() const;
    private:
        const TString Mask;
    };

    class TMaskedValue {
    public:
        explicit TMaskedValue(const TString& maskedValue)
        : MaskedValue(maskedValue)
        {}
        const TString& Get() const;
    private:
        const TString MaskedValue;
    };

    TMaybe<TString> Unmask(const TMask& mask, const TMaskedValue& maskedValue);
}
