#include "unmask.h"

#include <library/cpp/json/json_reader.h>
#include <util/stream/file.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NGraph::NMask;

Y_UNIT_TEST_SUITE(Unmask) {
    Y_UNIT_TEST(JsCompliance) {
        TFileInput in(ArcadiaSourceRoot() + "/crypta/graph/rtmr/lib/parse_adstat_log/unmask/ut/encoderMap.json");

        NJson::TJsonValue parsed;
        NJson::ReadJsonTree(in.ReadAll(), &parsed);

        for (const auto& entry : parsed["tests"].GetArray()) {
            const auto& uid = entry["uid"].GetString();
            const auto& mask = entry["mask"].GetString();
            const auto& maskedUid = entry["maskedUid"].GetString();

            const auto& unmasked = Unmask(TMask{mask}, TMaskedValue{maskedUid});
            UNIT_ASSERT(unmasked);
            UNIT_ASSERT_EQUAL(*unmasked, uid);
        }

        const auto& minimalLength = Unmask(TMask{"8584911679064055"}, TMaskedValue{"1073741824103746"});
        UNIT_ASSERT(minimalLength);
        UNIT_ASSERT_EQUAL(*minimalLength, "3599830255149791");
    }

    Y_UNIT_TEST(InvalidData) {
        const auto wrongLength = Unmask(TMask{"858491167906405597"}, TMaskedValue{"10737418241073741"});
        UNIT_ASSERT(!wrongLength);

        const auto& wrongChar = Unmask(TMask{"858491167906405597"}, TMaskedValue{"107374182410x3741"});
        UNIT_ASSERT(!wrongChar);

        const auto& insufficientLength = Unmask(TMask{"858491167906405"}, TMaskedValue{"107374182410374"});
        UNIT_ASSERT(!insufficientLength);

        const auto& empty = Unmask(TMask{""}, TMaskedValue{""});
        UNIT_ASSERT(!empty);
    }
}
