#pragma once

#include <crypta/graph/rtmr/lib/resources/resources.h>
#include <crypta/graph/rtmr/proto/parsed_bs_watch_row.pb.h>
#include <crypta/lib/native/ip_filter/ip_filter.h>
#include <crypta/lib/native/rtmr/tskv_parser_mapper/tskv_parser_mapper.h>
#include <rtmapreduce/libs/mapreduce-yt/operation.h>
#include <kernel/geo/utils.h>

namespace NCrypta::NGraph {
    class TParseBsWatchLog: public TTskvParserMapper  {
    public:
        TParseBsWatchLog(const TResources& resources, const TGeobaseLookup& geoData);
        ~TParseBsWatchLog() override = default;

        void DoParsed(const NYT::TNode& parsed, TWriter* writer) override;

    private:
        enum EOutputTo {
            JoinRedir = 0,
            Logbroker = 1,
            JoinSsl = 2,
            JoinYClid = 3,
            JoinYSClid = 3, // use the same reducer for yclid and ysclid
            ToExtFp = 4,
            ToExtFpDelayed = 5,
            ToDeduplicator = 6,
            Errors = 7
        };

        TString SelectIP(const NYT::TNode& node);

        const TGeobaseLookup& GeoData;
        const TResources& Resources;
    };
}
