#pragma once

#include <crypta/graph/rtmr/lib/resources/resources.h>
#include <crypta/graph/rtmr/proto/yuid_message.pb.h>
#include <rtmapreduce/libs/mapreduce-yt/operation.h>

namespace NCrypta::NGraph {
    class TParseExtfpMatchLog: public NYT::IMapper<NYT::TYaMRReader, NYT::TYaMRWriter> {
    public:
        TParseExtfpMatchLog(const TResources& resources);
        void Do(TReader* reader, TWriter* writer) override;

    private:
        void ParseAndWrite(const TReader::TRowType&, const uatraits::detector&, TWriter*);
        TString CreateJoinKey(const TString& ext_source, const TString& extfp, const TString& userAgent) const;
        enum EOutputTable {
            JoinExtfpAndUa,
            Errors
        };

        const TResources& Resources;
    };
}
