#pragma once

#include <crypta/graph/rtmr/proto/yuid_message.pb.h>
#include <crypta/graph/rtmr/proto/parsed_bs_watch_row.pb.h>
#include <crypta/graph/rtmr/lib/resources/resources.h>

#include <rtmapreduce/libs/mapreduce-yt/operation.h>
#include <logfeller/lib/log_parser/tskv_log_parser.h>

namespace NCrypta::NGraph {
    class TTskvParser: public NLogFeller::NLogParser::TTskvLogParser {
    public:
        TTskvParser()
            : TLogParser({})
            , TTskvLogParser({})
        {
        }
        void Parse(TStringBuf rawRecord, NYT::TNode& parsed);
    };

    class TParseRedirLog: public NYT::IMapper<NYT::TYaMRReader, NYT::TYaMRWriter> {
    public:
        TParseRedirLog(const TResources& resources);
        void Do(TReader* reader, TWriter* writer) override;

    private:
        void ParseAndWrite(const TReader::TRowType&, const uatraits::detector&, TWriter*);
        enum EOutputTable {
            OutputFp,
            OutputYSclid,
            Errors
        };

        TTskvParser Parser;
        const TResources& Resources;
    };
}
