#include "resources.h"

#include <crypta/lib/native/juggler/juggler_client.h>
#include <crypta/lib/native/resource_service/client/client.h>

#include <library/cpp/resource/resource.h>

#include <util/system/env.h>

using namespace NCrypta::NResourceService;
using namespace NCrypta::NGraph;

namespace {
    template <typename T>
    const T& CaptureResource(TResourcePtr<T>& resourcePtr, const IProvider<T>& provider) {
        if (!resourcePtr) {
            resourcePtr = provider.GetResource();
        }
        return resourcePtr->Value;
    }
}

TResources::TDefaultResources::TDefaultResources()
    : Config(TConfigParser::Parse(NResource::Find("config.yaml")))
    , UatraitsDetector(MakeDefaultUatraitsDetector())
    , Sources(MakeSourcesFromResource("sources.tgz"))
{
}

TResources::TResources(const NResourceService::TServiceOptions& options, TDefaultResources defaultResources)
    : ConfigProvider(std::move(defaultResources.Config), "graph_task_config")
    , UatraitsDetectorProvider(std::move(defaultResources.UatraitsDetector), "uatraits_data")
    , SourcesProvider(std::move(defaultResources.Sources), "extfp_ipfilter")
    , ResourceService(options, {ConfigProvider, UatraitsDetectorProvider, SourcesProvider})
{
}

TResources::TResourcesHolder TResources::GetHolder() const {
    return TResourcesHolder(*this);
}

TResources::TResourcesHolder::TResourcesHolder(const TResources& resources)
    : Resources(resources) {
}

const TConfig& TResources::TResourcesHolder::GetConfig() & {
    return CaptureResource(ConfigPtr, Resources.ConfigProvider);
}

const uatraits::detector& TResources::TResourcesHolder::GetUatraitsDetector() & {
    return *CaptureResource(UatraitsDetectorPtr, Resources.UatraitsDetectorProvider);
};

const TSourcesDescriptions& TResources::TResourcesHolder::GetSources() & {
    return CaptureResource(Sources, Resources.SourcesProvider);
};

namespace NCrypta::NGraph {
    const NResourceService::TSourceDescription* FindFirstPassing(const NResourceService::TSourcesDescriptions& sources, const TStringBuf ip, const TStringBuf sourceId) {
        if (auto it = FindIf(sources.begin(), sources.end(), [&ip, &sourceId](const auto& source) {
            return source.IsPassing(ip, sourceId);
        }); it != sources.end()) {
            return &(*it);
        } else {
            return nullptr;
        };
    }
}
