#pragma once

#include <crypta/graph/rtmr/proto/config.pb.h>
#include <crypta/lib/native/resource_service/parsers/yaml_config_parser/yaml_config_parser.h>
#include <crypta/lib/native/resource_service/parsers/extfp_source_parser/extfp_source_parser.h>
#include <crypta/lib/native/resource_service/parsers/uatraits_parser/uatraits_parser.h>
#include <crypta/lib/native/resource_service/provider/updatable_provider.h>
#include <crypta/lib/native/resource_service/service/service.h>
#include <crypta/lib/proto/resource_service/service_options.pb.h>


namespace NCrypta::NGraph {
    class TResources {
        using TConfigParser = NResourceService::TYamlConfigParser<TConfig>;

    public:
        class TResourcesHolder {
        public:
            explicit TResourcesHolder(const TResources& resources);

            const TConfig& GetConfig() &;
            const uatraits::detector& GetUatraitsDetector() &;
            const NResourceService::TSourcesDescriptions& GetSources() &;

        private:
            NResourceService::TResourcePtr<TConfig> ConfigPtr = nullptr;
            NResourceService::TResourcePtr<THolder<uatraits::detector>> UatraitsDetectorPtr = nullptr;
            NResourceService::TResourcePtr<NResourceService::TSourcesDescriptions> Sources = nullptr;

            const TResources& Resources;
        };

        struct TDefaultResources {
            TConfig Config;
            THolder<uatraits::detector> UatraitsDetector;
            NResourceService::TSourcesDescriptions Sources;

            TDefaultResources();
        };

        TResources(const NResourceService::TServiceOptions& options, TDefaultResources defaultResources = TDefaultResources());

        TResourcesHolder GetHolder() const;

    private:
        NResourceService::TUpdatableProvider<TConfig, TConfigParser> ConfigProvider;
        NResourceService::TUpdatableProvider<THolder<uatraits::detector>, NResourceService::TUatraitsParser> UatraitsDetectorProvider;
        NResourceService::TUpdatableProvider<NResourceService::TSourcesDescriptions, NResourceService::TExtfpSourceParser> SourcesProvider;
        NResourceService::TService ResourceService;
    };

    const NResourceService::TSourceDescription* FindFirstPassing(const NResourceService::TSourcesDescriptions& sources, const TStringBuf ip, const TStringBuf sourceId);
}
