#pragma once

#include <crypta/graph/rtmr/proto/tls_reducer_state.pb.h>
#include <crypta/graph/rtmr/proto/parsed_bs_watch_row.pb.h>
#include <crypta/lib/native/rtmr/proto_stateful_operation/proto_stateful_operation.h>

namespace NCrypta::NGraph {
    class TTlsReducer: public TProtoStatefulReducer<TTlsReducerState> {
    public:
        void Do(TReader* reader, TWriter* writer) override;
        static const int MaxAllowedDuids = 1000;

    private:
        enum EOutputTo {
            Logbroker = 0,
            Errors = 1
        };
        enum class EDecision {
            Skip,
            UploadOnce, // upload just this match
            UploadAll   // upload all in seen duids
        };

        bool IsNewYandexuidBetter(const TString&, const TString&);
        EDecision CheckAndModifyState(const TParsedBsWatchRow& message);
    };
}
