#include "yclid_reducer.h"
#include <crypta/graph/rtmr/lib/common/serialize_fingerprint_match.h>
#include <crypta/lib/native/time/shifted_clock.h>
#include <library/cpp/protobuf/json/proto2json.h>

using namespace NCrypta::NGraph;

void TYClidReducer::Do(TReader* reader, TWriter* writer) {
    TShiftedClock::FreezeTimestampFromEnv();

    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();
        /* do not upload matching if we've already seen the yclid : https://st.yandex-team.ru/METR-32923#5d136f1bd0bf370021d76a55 */
        if (!State.GetYuid().empty() && !State.GetFpc().empty()) {
            return;
        }
        try {
            TParsedBsWatchRow message;
            const auto yuid = State.GetYuid();
            Y_PROTOBUF_SUPPRESS_NODISCARD message.ParseFromString(TString{row.Value});
            State.MergeFrom(message);
            if (State.GetSource().empty()) {
                State.SetSource("yclid");
            }

            if (!yuid.empty()) {
                State.SetYuid(yuid);
            }

            if (!State.GetYuid().empty() && !State.GetFpc().empty()) {
                writer->AddRow({row.Key, row.SubKey, SerializeMatch(State.GetYuid(), State, State.GetSource())}, EOutputTo::Logbroker);
                return;
            }
        } catch (const yexception& e) {
            writer->AddRow({row.Key, row.SubKey, e.what()}, EOutputTo::Errors);
        }
    }
}
