# encoding: utf-8

from crypta.lib.python.data_size import DataSize
from crypta.lib.python.spine import (
    logfeller,
    rtmr_utils,
)
from crypta.lib.python.spine.juggler.juggler_check_generator import JugglerCheckGenerator


def get_registry():
    juggler_check_generator = JugglerCheckGenerator(tags=["crypta-rt-graph", "crypta-idfy-telegram-alert"])

    for stream in [
        "crypta@prod@graph-fingerprint-matching",
    ]:
        logfeller.add_unprased_records_check(juggler_check_generator, stream)

    output_operations = [
        rtmr_utils.OutputOperationConfig("rtcrypta_graph_pqout_fingerprint_matching", escalation=False),
    ]

    operations = [
        rtmr_utils.ProcessingOperationConfig("bs_event_mapper"),
        rtmr_utils.ProcessingOperationConfig("bs_hit_mapper"),
        rtmr_utils.ProcessingOperationConfig("hitlogid_reducer", fail_threshold=500),
        rtmr_utils.ProcessingOperationConfig("join_fingerprints"),
        rtmr_utils.ProcessingOperationConfig("parse_bs_watch_log", error_threshold=100),
        rtmr_utils.ProcessingOperationConfig("parse_extfp_match_log"),
        rtmr_utils.ProcessingOperationConfig("parse_redir_log", error_threshold=1000),
        rtmr_utils.ProcessingOperationConfig("parse_zen_log"),
        rtmr_utils.ProcessingOperationConfig("tls_reducer"),
        rtmr_utils.ProcessingOperationConfig("yclid_reducer"),
    ]

    resources = [
        "resource/uatraits_data",
        "resource/graph_task_config",
    ]

    operations_for_total_delivery_time = [
        rtmr_utils.OperationForTotalDeliveryTimeConfig("join_fingerprints", threshold_seconds=rtmr_utils.TotalDeliveryTime.SECONDS_15),
        rtmr_utils.OperationForTotalDeliveryTimeConfig("tls_reducer", threshold_seconds=rtmr_utils.TotalDeliveryTime.SECONDS_15),
        rtmr_utils.OperationForTotalDeliveryTimeConfig("hitlogid_reducer", threshold_seconds=rtmr_utils.TotalDeliveryTime.SECONDS_15),
        rtmr_utils.OperationForTotalDeliveryTimeConfig("yclid_reducer", threshold_seconds=rtmr_utils.TotalDeliveryTime.SECONDS_15),
    ]

    tracked_state_sizes = [
        rtmr_utils.StateSizeConfig("join_fingerprints", threshold=DataSize(gb=7)),
        rtmr_utils.StateSizeConfig("tls_reducer", threshold=DataSize(gb=3)),
        rtmr_utils.StateSizeConfig("hitlogid_reducer", threshold=DataSize(gb=5)),
        rtmr_utils.StateSizeConfig("yclid_reducer", threshold=DataSize(mb=50)),
    ]

    tracked_table_sizes = [
        rtmr_utils.TableSizeConfig("rtcrypta_graph/fingerprint_matches", threshold=DataSize(mb=20)),
        rtmr_utils.TableSizeConfig("rtcrypta_graph/to_fpextmatcher", threshold=DataSize(mb=0)),
    ]

    rtmr_utils.create_checks(
        juggler_check_generator,
        task_name="rtcrypta_graph",
        project_id="crypta_graph",
        solomon_service="rt_fingerprint_matching",
        output_operations=output_operations,
        processing_operations=operations,
        operations_for_total_delivery_time=operations_for_total_delivery_time,
        resources=resources,
        tracked_state_sizes=tracked_state_sizes,
        tracked_table_sizes=tracked_table_sizes,
    )

    return juggler_check_generator
